//
//  ViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "ViewController.h"
#import <AdViewSDK/AdViewSDK.h>
#import <AdViewSDK/AdViewView.h>




@interface ViewController ()
@property (nonatomic, strong) NSMutableArray <UILabel *>* buttonArray;
@end

@implementation ViewController

- (NSMutableArray *)buttonArray {
    if (!_buttonArray) {
        _buttonArray = [NSMutableArray new];
    }
    return _buttonArray;
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self.navigationController setNavigationBarHidden:YES animated:YES];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    // GDPR and CCPA save example in NSUserDefaults
    /*AdView_IABConsent_CMPPresent = "IABConsent_CMPPresent";
    AdView_IABConsent_SubjectToGDPR = "IABConsent_SubjectToGDPR";
    AdView_IABConsent_ConsentString = "IABConsent_ConsentString";
    AdView_IABConsent_ParsedPurposeConsents = "IABConsent_ParsedPurposeConsents";
    AdView_IABConsent_ParsedVendorConsents = "IABConsent_ParsedVendorConsents";
    AdView_IABConsent_CCPA = "IABUSPrivacy_String";*/
    /*[[NSUserDefaults standardUserDefaults] setObject:@"testCMPPresent" forKey:AdView_IABConsent_CMPPresent];
    [[NSUserDefaults standardUserDefaults] setObject:@"1" forKey:AdView_IABConsent_SubjectToGDPR];
    [[NSUserDefaults standardUserDefaults] setObject:@"testConsentString" forKey:AdView_IABConsent_ConsentString];
    [[NSUserDefaults standardUserDefaults] setObject:@"testPurposeConsents" forKey:AdView_IABConsent_ParsedPurposeConsents];
    [[NSUserDefaults standardUserDefaults] setObject:@"testVendorConsents" forKey:AdView_IABConsent_ParsedVendorConsents];
    [[NSUserDefaults standardUserDefaults] setObject:@"testCCPA" forKey:AdView_IABConsent_CCPA];*/
    
    /*GPP save example in NSUserDefaults
    AdView_IABGPP_GppString = "IABGPP_HDR_GppString";
    AdView_IABGPP_GppSID =  "IABGPP_GppSID" */
    //[[NSUserDefaults standardUserDefaults] setObject:@"testGpp" forKey:AdView_IABGPP_GppString];
    //[[NSUserDefaults standardUserDefaults] setObject:@"1,2" forKey:AdView_IABGPP_GppSID];
    

    NSArray <NSString *>* buttonTtitleArray = @[NSLocalizedString(@"REQ_SPREAD", nil),
                                                NSLocalizedString(@"REQ_BANNER", nil),
                                                NSLocalizedString(@"REQ_MREC", nil),
                                                NSLocalizedString(@"REQ_INTERSTITIAL", nil),
                                                NSLocalizedString(@"REQ_VIDEO", nil),
                                                NSLocalizedString(@"REQ_TWO_STEP_VIDEO", nil),
                                                NSLocalizedString(@"REQ_NATIVE", nil)];
    
    NSArray <UIColor *>* buttonColorArray = @[[self.class hexStringToColor:@"#1070B4"],
                                              [self.class hexStringToColor:@"#C58125"],
                                              [self.class hexStringToColor:@"#178CE6"],
                                              [self.class hexStringToColor:@"#B12531"],
                                              [self.class hexStringToColor:@"#29A199"],
                                              [self.class hexStringToColor:@"#50b425"],
                                              [self.class hexStringToColor:@"#7459A7"]];
    
    SEL selectorArray[10] = {@selector(spreadViewController:),
        @selector(bannerViewController:),
        @selector(MRECViewController:),
        @selector(interstitialViewController:),
        @selector(videoViewController:),
        @selector(twoStepVideoViewController:),
        @selector(nativeViewController:)};
    
    for (int i = 0; i < buttonTtitleArray.count; i++) {
        UILabel * button = [UILabel new];
        [button setText:buttonTtitleArray[i]];
        [button setTextColor:[UIColor whiteColor]];
        [button setTextAlignment:NSTextAlignmentCenter];
        [button setBackgroundColor:buttonColorArray[i]];
        UITapGestureRecognizer * tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:selectorArray[i]];
        [button addGestureRecognizer:tap];
        [button setUserInteractionEnabled:YES];
        [self.view addSubview:button];
        [self.buttonArray addObject:button];
    }

}

- (void)spreadViewController:(UITapGestureRecognizer *)recognizer {
    
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    
    [self.navigationController pushViewController:[[SpreadViewController alloc]init] animated:YES];
}

- (void)bannerViewController:(UITapGestureRecognizer *)recognizer {
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    
    [self.navigationController pushViewController:[[BannerViewController alloc]init] animated:YES];
}

- (void)MRECViewController:(UITapGestureRecognizer *)recognizer {
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    
    [self.navigationController pushViewController:[[MRECViewController alloc]init] animated:YES];
}

- (void)interstitialViewController:(UITapGestureRecognizer *)recognizer {
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    
    [self.navigationController pushViewController:[[InterstitialViewController alloc]init] animated:YES];
}


- (void)videoViewController:(UITapGestureRecognizer *)recognizer {
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    
    [self.navigationController pushViewController:[[VideoViewController alloc]init] animated:YES];
}

- (void)twoStepVideoViewController:(UITapGestureRecognizer *)recognizer {
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    
    [self.navigationController pushViewController:[[TwoStepVideoViewController alloc]init] animated:YES];
}
- (void)nativeViewController:(UITapGestureRecognizer *)recognizer {
    if (@available(iOS 13.0, *)) {
        UINavigationBarAppearance *appearance = [UINavigationBarAppearance new];
        [appearance configureWithOpaqueBackground];
        appearance.backgroundColor = recognizer.view.backgroundColor;
        self.navigationController.navigationBar.standardAppearance = appearance;
        self.navigationController.navigationBar.scrollEdgeAppearance=self.navigationController.navigationBar.standardAppearance;
    } else {
        // Fallback on earlier versions
        self.navigationController.navigationBar.barTintColor = recognizer.view.backgroundColor;
    }
    [self.navigationController pushViewController:[[NativeViewController alloc]init] animated:YES];
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    
    CGFloat buttonCount  = self.buttonArray.count;
    CGFloat buttonWidth  = self.view.frame.size.width - SPACE * 2;
    CGFloat buttonHeight = SPACE * 3;
    CGFloat buttonX = SPACE;
    CGFloat buttonY = self.view.frame.size.height / 2 - buttonCount * buttonHeight + SPACE * (buttonCount - 1);
    for (UILabel * button in self.buttonArray) {
        NSUInteger index = [self.buttonArray indexOfObject:button];
        button.frame = CGRectMake(buttonX, buttonY + index * (buttonHeight + SPACE), buttonWidth, buttonHeight);
    }
}

+ (UIColor *)hexStringToColor:(NSString *)stringToConvert {
    NSString *cString = [[stringToConvert stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]] uppercaseString];
    
    if ([cString length] < 6) return [UIColor blackColor];

    if ([cString hasPrefix:@"0X"]) cString = [cString substringFromIndex:2];
    if ([cString hasPrefix:@"#"]) cString = [cString substringFromIndex:1];
    if ([cString length] != 6 && [cString length] != 8) return [UIColor blackColor];
    
    NSRange range;
    range.location = 0;
    range.length = 2;
    NSString *aString = @"255";
    if ([cString length] == 8) {
        aString = [cString substringWithRange:range];
        range.location += 2;
    }
    NSString *rString = [cString substringWithRange:range];
    range.location += 2;
    NSString *gString = [cString substringWithRange:range];
    range.location += 2;
    NSString *bString = [cString substringWithRange:range];
    
    unsigned int r, g, b, a;
    [[NSScanner scannerWithString:rString] scanHexInt:&r];
    [[NSScanner scannerWithString:gString] scanHexInt:&g];
    [[NSScanner scannerWithString:bString] scanHexInt:&b];
    [[NSScanner scannerWithString:aString] scanHexInt:&a];
    
    return [UIColor colorWithRed:((float) r / 255.0f)
                           green:((float) g / 255.0f)
                            blue:((float) b / 255.0f)
                           alpha:((float) a / 255.0f)];
}
@end
